/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.util;

import java.io.IOException;
import me.lucko.spark.common.util.AbstractHttpClient;
import me.lucko.spark.lib.okhttp3.MediaType;
import me.lucko.spark.lib.okhttp3.OkHttpClient;
import me.lucko.spark.lib.okhttp3.Request;
import me.lucko.spark.lib.okhttp3.RequestBody;
import me.lucko.spark.lib.okhttp3.Response;

public class BytebinClient
extends AbstractHttpClient {
    private final String url;
    private final String userAgent;

    public BytebinClient(OkHttpClient okHttpClient, String url, String userAgent) {
        super(okHttpClient);
        this.url = url + (url.endsWith("/") ? "" : "/");
        this.userAgent = userAgent;
    }

    public Content postContent(byte[] buf, MediaType contentType) throws IOException {
        RequestBody body = RequestBody.create(contentType, buf);
        Request.Builder requestBuilder = new Request.Builder().url(this.url + "post").header("User-Agent", this.userAgent).header("Content-Encoding", "gzip");
        Request request = requestBuilder.post(body).build();
        try (Response response = this.makeHttpRequest(request);){
            String key = response.header("Location");
            if (key == null) {
                throw new IllegalStateException("Key not returned");
            }
            Content content = new Content(key);
            return content;
        }
    }

    public static final class Content {
        private final String key;

        Content(String key) {
            this.key = key;
        }

        public String key() {
            return this.key;
        }
    }
}

